///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	This file contains all the basic information structures.
 *	\file		FLX_BaseInfo.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __FLX_BASEINFO_H__
#define __FLX_BASEINFO_H__

	enum ObjType
	{
		OBJ_UNDEFINED	= 0,
		OBJ_CAMERA		= 1,
		OBJ_LIGHT		= 2,
		OBJ_MESH		= 3,
		OBJ_BPATCH		= 4,
		OBJ_CONTROLLER	= 5,
		OBJ_HELPER		= 6,
		OBJ_MATERIAL	= 7,
		OBJ_TEXTURE		= 8,
		OBJ_MOTION		= 9,
		OBJ_SHAPE		= 10,
		OBJ_FORCE_DWORD	= 0x7fffffff
	};

	//! This class holds the main information about the scene
	class MainDescriptor
	{
		public:
		//! Constructor/Destructor
										MainDescriptor() : mNbNodes(0), mNbCharacters(0)	{}
										~MainDescriptor()									{}

						MAXTimeInfo		mTime;					//!< Time-related information
						udword			mNbNodes;				//!< Number of expected nodes
						udword			mNbCharacters;			//!< Number of expected characters
						MAXPoint		mBackColor;				//!< Background color [animatable]
						MAXPoint		mAmbColor;				//!< Ambient light color [animatable]
						char*			mSceneInfos;			//!< Scene infos (in SummaryInfo)
	};

	//! The base information class for each object
	class ObjectDescriptor
	{
		public:
		//! Constructor
										ObjectDescriptor()
										{
											mName				= null;
											mIsGroupMember		= false;
											mLocalPRS			= false;
											mObjectID			= -1;
											mParentID			= -1;
											mLinkID				= -1;
											mType				= OBJ_UNDEFINED;
											mWireColor			= 0;
											mUserProps			= null;
										}
		//! Destructor
		virtual							~ObjectDescriptor()		{}

		// Database management
						ubyte*			mName;					//!< Object's name
						bool			mIsGroupMember;			//!< Belonging to a group
						sdword			mObjectID;				//!< Object's ID
						sdword			mParentID;				//!< Father's ID
						sdword			mLinkID;				//!< Possible link reference
						ObjType			mType;					//!< Object's type
		// Common properties
						MAXPRS			mPrs;					//!< Position/Rotation/Scale
						MAXPoint		mPivotPos;				//!< Pivot position
						MAXQuat			mPivotRot;				//!< Pivot rotation
						bool			mLocalPRS;				//!< True for local PRS, false for absolute ones.
						bool			mD3DCompliant;			//!< Object has been converted to D3D frame
						udword			mWireColor;				//!< Object's Wire Color in MAX
						ubyte*			mUserProps;				//!< User-defined properties
	};

	//! Statistics class
	class StatsDescriptor
	{
		public:
		//! Constructor
										StatsDescriptor()
										{
											mNbGeomObjects		= 0;
											mNbDerivedObjects	= 0;
						//					mNbBPatchObjects	= 0;
											mNbCameras			= 0;
											mNbLights			= 0;
											mNbShapes			= 0;
											mNbHelpers			= 0;
											mNbControllers		= 0;
											mNbMaterials		= 0;
											mNbTexmaps			= 0;
											mNbUnknowns			= 0;
											mNbInvalidNodes		= 0;
						//					mNbBipedParts		= 0;
						//					mNbCharacters		= 0;
										}
		//! Destructor
										~StatsDescriptor()		{}

						udword			mNbGeomObjects;			//!< Number of geomobjects found
						udword			mNbDerivedObjects;		//!< Number of derived objects found (actually number of skins)
		//				udword			mNbBPatchObjects;		//!< Number of BPatch objects found
						udword			mNbCameras;				//!< Number of cameras found
						udword			mNbLights;				//!< Number of lights found
						udword			mNbShapes;				//!< Number of shapes found
						udword			mNbHelpers;				//!< Number of helpers found
						udword			mNbControllers;			//!< Number of controllers found
						udword			mNbMaterials;			//!< Number of materials found
						udword			mNbTexmaps;				//!< Number of texmaps found
						udword			mNbUnknowns;			//!< Number of unknown nodes found
						udword			mNbInvalidNodes;		//!< Number of invalid nodes found
		//				udword			mNbBipedParts;			//!< Number of biped nodes found
		//				udword			mNbCharacters;			//!< Number of characters found
	};

#endif // __FLX_BASEINFO_H__
